SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Sp_UpdateRespondentResponse]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[Sp_UpdateRespondentResponse]
GO

DECLARE @version varchar(128), @majorversion int
SET @version = CAST(SERVERPROPERTY('productversion') as varchar(128))
SET @majorversion = SUBSTRING(@version,1,CHARINDEX('.',@version,0)-1) --MERGE is only supported on SQL2008 and above
IF @majorversion >= 10 AND NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Sp_UpdateRespondentResponse]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'

CREATE PROCEDURE [dbo].[Sp_UpdateRespondentResponse]
 @ProjectId     INT,
 @UserId        INT,
 @CollectMode   INT,
 @RpsRespondent VARCHAR(10),
 @RpsQuestion   VARCHAR(32),
 @RpsMatrix     BIGINT,
 @RpsMention    INT,
 @RpsContent    NVARCHAR(100),
 @rpsOpened     NTEXT,
 @rpsType       INT,
 @CallId        INT,
 @Source        nvarchar(max),
 @Modified      datetime = null
AS

 IF @Modified is null SET @Modified = GETUTCDATE();
 
 MERGE Response as target
 USING (SELECT @RpsRespondent, @RpsQuestion, @RpsMatrix, @RpsMention, @rpsType, -- PK
		@ProjectId, @UserId, @CollectMode, @RpsContent, @rpsOpened,  @CallId, @Source, @Modified) --Update field
	as source (Respondent, Question, Matrix, Mention, [Type],
		ProjectId, UserId, CollectMode, Content, Opened, CallId, [Source], Modified)
 ON (RpsRespondent = source.Respondent 
	and RpsQuestion = source.Question 
	and RpsMatrix = source.Matrix 
	and RpsMention = source.Mention 
	and RpsType = source.[Type])
 WHEN MATCHED THEN
	UPDATE SET ProjectId = source.ProjectId,
         CollectMode = CASE WHEN source.CollectMode < 0 THEN target.CollectMode ELSE source.CollectMode END,
         ModifiedBy = source.UserId,
         Modified = source.Modified,
         RpsContent = source.Content,
         RpsOpened = source.Opened,
         CallId = source.CallId,
         [Source] = source.[Source]
 WHEN NOT MATCHED THEN
	INSERT (RpsRespondent, RpsQuestion, RpsMatrix, RpsMention, RpsType,
		 ProjectId, CollectMode, ModifiedBy, Modified, RpsContent, RpsOpened, CallId, [Source])
	VALUES (Respondent, Question, Matrix, Mention, [Type],
		 ProjectId, CollectMode, UserId, Modified, Content, Opened, CallId, [Source]);


' 
END
ELSE
BEGIN
EXEC dbo.sp_executesql @statement = N'
CREATE PROCEDURE [dbo].[Sp_UpdateRespondentResponse]
 @ProjectId     INT,
 @UserId        INT,
 @CollectMode   INT,
 @RpsRespondent VARCHAR(10),
 @RpsQuestion   VARCHAR(32),
 @RpsMatrix     BIGINT,
 @RpsMention    INT,
 @RpsContent    NVARCHAR(100),
 @rpsOpened     NTEXT,
 @rpsType       INT,
 @CallId        INT,
 @Source        nvarchar(max),
 @Modified      datetime = null
AS

  IF @Modified is null SET @Modified = GETUTCDATE();

  UPDATE Response
  SET    ProjectId = @ProjectId,
         CollectMode = CASE WHEN @CollectMode < 0 THEN CollectMode ELSE @CollectMode END,
         modifiedby = @UserId,
         modified = @Modified,
         RpsContent = @RpsContent,
         RpsOpened = @RpsOpened,
         CallId = @CallId,
         [Source] = @Source
  WHERE  RpsRespondent = @RpsRespondent
         AND RpsQuestion = @RpsQuestion
         AND RpsMatrix = @RpsMatrix
         AND RpsMention = @RpsMention
         AND RpsType = @RpsType
  IF @@ROWCOUNT = 0
  BEGIN
    INSERT INTO Response
    (RpsRespondent,
     ProjectId,
     CollectMode,
     modifiedby,
     modified,
     RpsQuestion,
     RpsMatrix,
     RpsMention,
     RpsContent,
     RpsOpened,
     RpsType,
     CallId,
     [Source])
 VALUES    (@RpsRespondent,
     @ProjectId,
     @CollectMode,
     @UserId,
     @Modified,
     @RpsQuestion,
     @RpsMatrix,
     @RpsMention,
     @RpsContent,
     @rpsOpened,
     @rpsType,
     @CallId,
     @Source)
  END
'
END
GO

DECLARE @version varchar(128), @majorversion int
SET @version = CAST(SERVERPROPERTY('productversion') as varchar(128))
SET @majorversion = SUBSTRING(@version,1,CHARINDEX('.',@version,0)-1)
IF @majorversion >= 10 AND EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_UpdateRespondent]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[sp_UpdateRespondent]
GO

DECLARE @version varchar(128), @majorversion int
SET @version = CAST(SERVERPROPERTY('productversion') as varchar(128))
SET @majorversion = SUBSTRING(@version,1,CHARINDEX('.',@version,0)-1) --MERGE is only supported on SQL2008 and above
IF @majorversion >= 10 AND NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_UpdateRespondent]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[sp_UpdateRespondent]  
 @ProjectId int,
 @UserId int,
 @CollectMode int,
 @ResRespondent varchar(10),
 @ResLanguage int,
 @ResTimeZone int,
 @ResCallBackDate DateTime,
 @ResIntervCall varchar(10),
 @ResTimeSlot int,
 @ResCallCount int,
 @ResLastCallDate datetime,
 @ResVersion varchar(10),
 @ResPriority int,
 @ResCompleted bit,
 @ResConfidPhone bit,
 @ResSeed float,
 @ResPhone varchar(20),
 @ResCodeResult varchar(2),
 @ResWaveNo int,
 @ResBlocked bit,
 @ResCompPredictive bit,
 @ResCall bit,
 @ResMonitored bit,
 @ResLastCompQuest int,
 @ResPreviousCallDate DateTime,
 @ResWaveImportNo int,
 @ServerTimeZone int,
 @DialingMode int = NULL, -- Null => Don''t change;
 @IntLevel int = NULL, -- Null => Don''t change;
 @RestrictionOverride bit = NULL -- Null => Don''t change;
AS

 MERGE Respondent as target
 USING (SELECT @ResRespondent, @ProjectId, @UserId, @CollectMode, @ResLanguage, @ResTimeZone, @ResCallBackDate, @ResIntervCall,
		@ResTimeSlot, @ResCallCount, @ResLastCallDate, @ResVersion, @ResPriority, @ResCompleted, @ResConfidPhone, @ResSeed,
		@ResPhone, @ResCodeResult, @ResWaveNo, @ResBlocked, @ResCompPredictive, @ResCall, @ResMonitored, @ResLastCompQuest,
		@ResPreviousCallDate, @ResWaveImportNo, @ServerTimeZone, @DialingMode, @IntLevel, @RestrictionOverride)
 	as source (Respondent, ProjectId, UserId, CollectMode, [Language], TimeZone, CallBackDate, IntervCall,
		TimeSlot, CallCount, LastCallDate, [Version], [Priority], Completed, ConfidPhone, Seed,
		Phone, CodeResult, WaveNo, Blocked, CompPredictive, [Call], Monitored, LastCompQuest,
		PreviousCallDate, WaveImportNo, ServerTimeZone, DialingMode, IntLevel, RestrictionOverride)
 ON (ResRespondent = source.Respondent) 
 WHEN MATCHED THEN
	UPDATE SET ProjectId = source.ProjectId,
		collectMode = case when source.CollectMode <0 then target.CollectMode else source.CollectMode end,
		ModifiedBy = source.UserId,
		Modified = GETUTCDATE(),
		ResLanguage = source.[Language],
		ResTimeZone = source.TimeZone,
		ResCallbackDate = dbo.VX_fn_ToUTC(source.CallBackDate, source.ServerTimeZone),
		ResIntervCall = source.IntervCall,
		ResTimeSlot = source.TimeSlot,
		ResCallCount = source.CallCount,
		ResLastCallDate = source.LastCallDate,
		ResVersion = source.[Version],
		ResPriority = source.[Priority],
		ResCompleted = source.Completed,
		ResConfidPhone = source.ConfidPhone,
		ResSeed = source.Seed,
		Resphone = source.Phone,
		ResCodeResult = source.CodeResult,
		ResWaveNo = source.WaveNo,
		ResBlocked = source.Blocked,
		ResCompPredictive = source.CompPredictive,
		ResCall = source.[Call],
		ResMonitored = source.Monitored,
		ResLastCompQuest = source.LastCompQuest,
		ResPreviousCallDate = source.PreviousCallDate,
		ResWaveImportNo = source.WaveImportNo,
		DialingMode = IsNull(source.DialingMode,target.DialingMode), -- If not specified, leave original value
		IntLevel = IsNull(source.IntLevel,target.IntLevel),
		RestrictionOverride = IsNull(source.RestrictionOverride,target.RestrictionOverride)
 WHEN NOT MATCHED THEN
	INSERT (ResRespondent, ProjectId, CollectMode, ModifiedBy, Modified, ResLanguage, ResTimeZone, ResCallBackDate,
		ResIntervCall, ResTimeSlot, ResCallCount, ResLastCallDate, ResVersion, ResPriority, ResCompleted, ResConfidPhone,
		ResSeed, ResPhone, ResCodeResult, ResWaveNo, ResBlocked, ResCompPredictive, ResCall, ResMonitored, ResLastCompQuest,
		ResPreviousCallDate, ResWaveImportNo, DialingMode, IntLevel, RestrictionOverride)
	VALUES (Respondent, ProjectId, CollectMode, UserId, GETUTCDATE(), [Language], TimeZone, dbo.VX_fn_ToUTC(CallBackDate, ServerTimeZone),
		IntervCall, TimeSlot, CallCount, LastCallDate, [Version], [Priority], Completed, ConfidPhone,
		Seed, Phone, CodeResult, WaveNo, Blocked, CompPredictive, [Call], Monitored, LastCompQuest,
		PreviousCallDate, WaveImportNo, IsNull(DialingMode,0), IsNull(IntLevel,0), IsNull(RestrictionOverride,0));
		
' 
END
--ELSE
--BEGIN
--MAKE sure to provide a alternate sp_updaterespondent for SQL 2005 and lower if replacing this script
--END
GO

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Response]') AND name = N'IxRpsRespondent')
DROP INDEX [IxRpsRespondent] ON [dbo].[Response] WITH ( ONLINE = OFF )
GO

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Response]') AND name = N'IxRpsQuestion')
DROP INDEX [IxRpsQuestion] ON [dbo].[Response] WITH ( ONLINE = OFF )
GO

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Respondent]') AND name = N'IxResCallBackDate')
DROP INDEX [IxResCallBackDate] ON [dbo].[Respondent] WITH ( ONLINE = OFF )
GO
